/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/


/* ---------------------------------------------------------------
 * File: xexer.h 
 *       Prototypes for Exerciser functions
 * -----------------------------------------------------------------*/

#ifndef XEXERCISER_H_INCLUDED                               
#define XEXERCISER_H_INCLUDED

#include <xexerdef.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifndef CLI
#define CLI
#endif

/********************************************************************
  Exerciser Run *****************************************************
 *******************************************************************/

CLI bx_errtype EXPORT BestXExerciserRun(      /* @erun */
  bx_handletype  handle
);

CLI bx_errtype EXPORT BestXExerciserStop(     /* @estop */
  bx_handletype  handle
);

CLI bx_errtype EXPORT BestXExerciserPause(    /* @epause */
  bx_handletype  handle
);

CLI bx_errtype EXPORT BestXExerciserContinue( /* @econt */
  bx_handletype  handle
);

CLI bx_errtype EXPORT BestXExerciserClear(    /* @eclear */
  bx_handletype  handle
);

CLI bx_errtype EXPORT BestXExerciserBreak(    /* @ebreak */
  bx_handletype  handle
);

CLI bx_errtype EXPORT BestXExerciserReset(    /* @ereset */
  bx_handletype  handle
);

/********************************************************************
  Exerciser programming *********************************************
 *******************************************************************/

CLI bx_errtype EXPORT BestXExerciserProgMode(    /* @eprogmode */
  bx_handletype  handle,
  bx_int32 SoftForce
);

CLI bx_errtype EXPORT BestXExerciserRunMode(    /* @erunmode */
  bx_handletype  handle,
  bx_int32 SoftForce
);

CLI bx_errtype EXPORT BestXExerciserIsInProgMode( /* @eisinprogmode */
  bx_handletype handle,
  bx_int32 *ProgMode          /* #RETURN "%lu" */
);

CLI bx_errtype EXPORT BestXExerciserProg(    /* @eprog */
  bx_handletype  handle
);

CLI bx_errtype EXPORT BestXExerciserRead(    /* @eread */
  bx_handletype  handle,
  bx_int32 option
);

/********************************************************************
  Exerciser generics ************************************************
 *******************************************************************/

CLI bx_errtype EXPORT BestXExerciserGenGet(             /* @egenget */
  bx_handletype  handle,
  bx_egentype    prop,                               
  bx_int32       *val                                   /* #RETURN "0x%08lx" */
);

CLI bx_errtype EXPORT BestXExerciserGenSet(             /* @egenset */
  bx_handletype  handle,
  bx_egentype    prop,                                  
  bx_int32       val                                   
);

CLI bx_errtype EXPORT BestXExerciserGenDefaultSet(   /* @egendefset */
  bx_handletype  handle
);

CLI bx_errtype EXPORT BestXExerciserGenProg(   /* @egenprog */
  bx_handletype  handle
);

CLI bx_errtype EXPORT BestXExerciserGenRead(   /* @egenread */
  bx_handletype  handle
);

CLI bx_errtype EXPORT BestXExerciserDefaultSet( /* @edefset */
  bx_handletype  handle
);


#ifdef __cplusplus
}
#endif

#endif






